package app.firezone.synk.network.Adapter;

import android.os.Bundle;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentPagerAdapter;

import app.firezone.synk.network.Fragments.BgmiOngoingFragment;
import app.firezone.synk.network.Fragments.Bgmi_Result_Fragment;
import app.firezone.synk.network.Fragments.Bgmi_Upcoming_Fragment;

public class TabAdapter extends FragmentPagerAdapter {
    private final String gamename;

    public TabAdapter(@NonNull FragmentManager fm, String gamename) {
        super(fm, BEHAVIOR_RESUME_ONLY_CURRENT_FRAGMENT);
        this.gamename = gamename;
    }

    @NonNull
    @Override
    public Fragment getItem(int position) {
        Bundle bundle = new Bundle();
        bundle.putString("gamename", gamename);

        switch (position) {
            case 0:
                BgmiOngoingFragment ongoingFragment = new BgmiOngoingFragment();
                ongoingFragment.setArguments(bundle);
                return ongoingFragment;

            case 1:
                Bgmi_Upcoming_Fragment upcomingFragment = new Bgmi_Upcoming_Fragment();
                upcomingFragment.setArguments(bundle);
                return upcomingFragment;

            case 2:
                Bgmi_Result_Fragment resultFragment = new Bgmi_Result_Fragment();
                resultFragment.setArguments(bundle);
                return resultFragment;

            default:
                Bgmi_Upcoming_Fragment defaultFragment = new Bgmi_Upcoming_Fragment();
                defaultFragment.setArguments(bundle);
                return defaultFragment;
        }
    }

    @Nullable
    @Override
    public CharSequence getPageTitle(int position) {
        switch (position) {
            case 0: return "Ongoing";
            case 1: return "Upcoming";
            case 2: return "Result";
            default: return "Upcoming";
        }
    }

    @Override
    public int getCount() {
        return 3; // Number of tabs
    }
}
